(function(){
  function ready(fn){ if(document.readyState!=='loading'){fn()} else {document.addEventListener('DOMContentLoaded',fn);} }
  ready(function(){
    var rootId = (window.OCS_ADMIN_NOTES_DND && OCS_ADMIN_NOTES_DND.listId) || 'ocs-notes';
    var dragClass = (window.OCS_ADMIN_NOTES_DND && OCS_ADMIN_NOTES_DND.dragClass) || 'ocs-drag-hint';
    var list = document.getElementById(rootId);
    if(!list) return;

    var draggingEl = null;

    function serialize(){
      var ids = [];
      list.querySelectorAll('li[data-id]').forEach(function(li){ ids.push(li.getAttribute('data-id')); });
      var input = document.getElementById('ocs_order');
      if(input){ input.value = ids.join(','); }
    }

    list.querySelectorAll('li').forEach(function(li){
      li.addEventListener('dragstart', function(e){
        draggingEl = li;
        li.classList.add(dragClass);
        e.dataTransfer.effectAllowed = 'move';
        try { e.dataTransfer.setData('text/plain', li.getAttribute('data-id')); } catch(err){}
      });
      li.addEventListener('dragend', function(){
        li.classList.remove(dragClass);
        draggingEl = null;
        serialize();
      });
      li.addEventListener('dragover', function(e){
        e.preventDefault();
        e.dataTransfer.dropEffect = 'move';
        var target = li;
        if(!draggingEl || draggingEl===target) return;
        var rect = target.getBoundingClientRect();
        var before = (e.clientY - rect.top) < rect.height/2;
        if(before){
          list.insertBefore(draggingEl, target);
        } else {
          list.insertBefore(draggingEl, target.nextSibling);
        }
      });
      li.addEventListener('drop', function(e){
        e.preventDefault();
      });
    });

    // Initial serialize
    serialize();
  });
})();