// Minimal JS to mark toggle state and allow revealing notices on demand later.
(function($){
  $(function(){
    if(window.FocusAdmin && FocusAdmin.focusOn){
      $('#wp-admin-bar-focus-admin-toggle').addClass('focus-on');
      // Add a reveal notices chip
      var $btn = $('<button/>', { class: 'focus-admin-notices-reveal', text: 'Show Notices' });
      $btn.on('click', function(){
        // Toggle notice visibility
        var hidden = $('body').hasClass('focus-admin--on');
        // Instead of disabling focus entirely, just reveal notices temporarily
        if(hidden){
          // Temporarily show notices by adding a class
          $('body').toggleClass('focus-admin-show-notices');
          if($('body').hasClass('focus-admin-show-notices')){
            $('.notice, .update-nag').css('display','');
            $(this).text('Hide Notices');
          } else {
            $('.notice, .update-nag').css('display','none');
            $(this).text('Show Notices');
          }
        }
      });
      $('body').append($btn);
    }
  });
})(jQuery);
